#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//SectionsMod01.fsh   by  scry   
//https://www.shadertoy.com/view/lcVGDD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi acos(-1.)
#define deg pi/180.
#define time iTime*pi/10.
#define R iResolution.xy
#define ar R.x/R.y
mat2 r2d(float a){
    return mat2(cos(a),sin(a),-sin(a),cos(a));
}
vec3 cs = vec3(1.,2.,3.);
float g(vec2 uv, float th) {
    float col = (0.);
    float s = 10.;
    vec2 gv = (fract(uv*s-0.5)-0.5)/s;
    vec2 cv = vec2(length(uv),atan(uv.x,uv.y));
    cv.x = log(cv.x);
    col += smoothstep(th,0.,(min(abs(gv.x),abs(gv.y))));
    return col;
}
vec3 rgb2hsv(vec3 c){vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));float d = q.x - min(q.w, q.y);float e = 1.0e-10;return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);}vec3 hsv2rgb(vec3 c){vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);}float bitm(vec2 uv,int c) {float h = 5.;float w = 3.;int p = int(pow(2.,w));float line1 = 9591.;uv = floor(vec2(uv.x*w,uv.y*h))/vec2(w,w);float c1 = 0.;float cc = uv.x + uv.y*w;c1 = mod( floor( float(c) / exp2(ceil(cc*w-0.6))) ,2.);c1 *= step(0.,uv.x)*step(0.,uv.y);c1 *= step(0.,(-uv.x+0.99))*step(0.,(-uv.y+1.6));return (c1);}vec3 slogo(vec2 uv, float ar_, float size) {size = 240./size;uv.x = 1.-uv.x;vec2 px = vec2(1./3.,1./5.);float ls = 4.1;uv *= 240./5.25/size;ls += 2.;float ul = length(uv);ul = length(vec2(uv.x*0.5,uv.y)-0.5);uv -= 0.4;uv.x *= ar*1.75;uv.y *= 1.04;int s = 29671;int c = 29263;int r = 31469;int y = 23186;uv.x= 5.-uv.x;float b = bitm(uv,s);uv.x -= 1./3.*4.;b += bitm(uv,c);uv.x -= 1./3.*4.;b += bitm(uv,r);uv.x -= 1./3.*4.;b += bitm(uv,y);float rr = step(0.,uv.x+px.x*13.)*step(0.,uv.y+px.y)*step(0.,(-uv.x+px.x*4.))*step(0.,(-uv.y+px.y*6.));b = clamp(b,0.,1.);vec3 l = hsv2rgb(vec3(b+iTime/40.,0.1,rr-b*1.9))*rr;l -= 0.1-clamp(ul*0.1,rr*1.-b,0.1);return vec3(l);}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord.xy / iResolution.xy;
    vec2 tv = uv;
    uv -= 0.5;
    uv.x *= ar;
    vec3 col = vec3(0.);
    uv *= 0.8+sin(-time/10.)*0.5;
    float c = length(uv);
    float gs = 0.4;
    float at = atan(uv.x,uv.y);
    float gtime = time+sin(at)*2.;
    for (int i=0;i<180;i++) {
        float ii = float(i);
        uv += vec2(sin(-gtime*6.),cos(-gtime*6.))*0.003*gs;
        uv *= 1.+sin(gtime+c*6.+ii)*0.03*gs;
        col += g(uv,0.01+sin(ii*0.8+time)*0.01)*(sin(vec3(1.,2.,3.)+ii)*0.99+0.2)*0.05;
        //uv += 0.005;
        uv += vec2(sin(time+uv.y*50.+c*2.+sin(at+sin(time/2.+c*2.)*4.)*sin(time/4.)*2.),cos(time+uv.x*50.+c*2.))*0.005*gs;
        uv *= r2d(deg*-45.);
        uv += vec2(sin(time*4.+uv.x*14.),cos(-time*2.+uv.y*14.))*0.001*gs;
    }
    //col += smoothstep(0.01,0.,(min(abs(g2.x),abs(g2.y))));
    col += slogo(tv,1.,300./1.)*(sin(vec3(cs*0.6+tv.x*20.))*0.4+0.6)*0.1;
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

